#!/bin/bash
# Author:      Todor T. Zviskov (a.k.a. Warder) - http://warder.ath.cx:81/
# Name:        LNX-patch.sh
# Version:     0.2
# Description: A script to ease the process of applying my favorite linux
#              kernel 2.6.x patches.
# License:     GPL-2 - http://www.gnu.org/licenses/gpl.txt
# 
# Changes:     Moving the kernel tree to reflect the patch version

kver="2.6.9"
kdir="/usr/src"
wd=`pwd`

#mm="2.6.6-mm1"
#mmfix="mmfix.patch"
#bk="patch-2.6.4-rc1"

ck="patch-2.6.9-ck1"
#ck2="patch-O21int-ht4"
#ck3="patch-ht4-batch5"
#ck4="patch-2.6.0-am-5"

sm="supermount-2.0.4-2.6.9.patch"

lirc="lirc-2.6.9-20040318"
#lirc1="patch-lirc-20030806-test7_fix-bk.diff"
packet="packet-2.6.8-2.patch"
quickcam="qc-usb-0.6.0.patch"

nvidia="patch-nvidia"
#nvpatch="NVIDIA_kernel-1.0-5328-2.6.diff"
nvdrv="NVIDIA-Linux-x86-1.0-6111-pkg1"
nvver="1.0-6111"
nvrev="1.0.6111"
nvdoc="/usr/share/doc"

vt="VT6410.267.patch"
lnx="patch-LNX"

echo "This script is designed to help you patch your kernel."
if [ `whoami` != "root" ];then
	echo "Please run the script as root."
	exit 1
fi
if [ ! -f "$lnx" ];then
	echo "Please run this script from the directory it's located in, otherwise it won't work. (eg. cd /wherever/this/is; sh LNX-patch.sh)"
	exit 1
fi
echo -ne "Would you like to continue? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "n" ] || [ "$choise" = "N" ];then
	echo "Ok, fine...find a better way to do it."
	exit
fi

echo

if [ ! -d "$kdir/linux-$kver" ];then
	echo "You don't seem to have the kernel $kver sources unpacked in $kdir"
	echo -ne "Do you have linux-$kver.tar.bz2 already downloaded? [y/N]: N\b"
	choise="N"
	read choise
	if [ "$choise" = "y" ] || [ "$choise" = "Y" ];then
		echo -n "Please specily the full path to the file [eg. /home/me]: "
		read ksrcdir
		if [ ! -f "$ksrcdir/linux-$kver.tar.bz2" ];then
			echo "Cannot find $ksrcdir/linux-$kver.tar.bz2"
			echo
			echo "Please check where you put linux-$kver.tar.bz2 and run this script again"
			exit 1
		else
			echo -e "\nUnpacking the kernel source in $kdir..."
			sleep 1
			tar xfj "$ksrcdir"/linux-$kver.tar.bz2 -C $kdir
		fi
	else
		echo
		echo -ne "Would you like to try downloading linux-$kver.tar.bz2? (You have to be connected to the internet and have wget installed) [Y/n] Y\b"
		choise="Y"
		read choise
		if [ "$choise" = "n" ] || [ "$choise" = "N" ];then
			echo
			echo "Ok, download it manually, then restart the script."
			exit 1
		fi
		echo
		echo "Starting download in /tmp..."
		cd /tmp
		wget -c ftp://kernel.org/pub/linux/kernel/v2.6/linux-$kver.tar.bz2
		if [ ! -f linux-$kver.tar.bz2 ];then
			echo "Download was not successful, exitting..."
			cd $wd
			exit 1
		else
			cd $wd
			echo -e "\nUnpacking the kernel source in $kdir..."
			sleep 1
			tar xfvj /tmp/linux-$kver.tar.bz2 -C $kdir
		fi
	fi
fi

#echo
#echo -ne "Apply rc1 patch (Recommended)? [Y/n]: Y\b"
#choise="Y"
#read choise
#if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
# 	cd $kdir/linux-$kver
# 	patch -p1 <$wd/$bk
# 	patch -R -p1 <$wd/bk.patch
# 	cd "$wd"
#### 	lirc="patch-lirc-20030802-test7_fix-bk.diff"
#fi

echo

#echo -ne "Apply mm patches (Recommended)? [Y/n]: Y\b"
#echo -ne "Apply mm and ck performance patches (Recommended)? [Y/n]: Y\b"
echo -ne "Apply ck patches - staircase, etc. (Recommended)? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
	patch -p1 <$wd/$ck
#	patch -p1 <$wd/$ck2
#	patch -p1 <$wd/$ck3
#	patch -p1 <$wd/$ck4
#	patch -p1 <$wd/$mm
#	patch -R -p1 <$wd/$mmfix
	cd "$wd"
#	packet="packet-2.6.0-test4.patch"
####	lirc="patch-lirc-20030802-test6_fix-mm.diff"
####	sm="supermount-2.0.2-2.6.0-test5-mm2.patch"
fi
echo
####else
	echo -ne "Apply Supermount patch? [Y/n]: Y\b"
	choise="Y"
	read choise
	if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
		cd $kdir/linux-$kver
	        patch -p1 <$wd/$sm
		cd "$wd"
		packet="packet-2.6.8-2sm.patch"
	fi
	echo
####fi

echo

echo -ne "Apply lirc patch? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
#	echo -ne "Do you use lirc-0.7.0_pre2 or later? [y/N]: N\b"
#	choise="N"
#	read choise
#	if [ "$choise" = "y" ] || [ "$choise" = "Y" ];then
#		patch -p1 <$wd/$lirc1
#	else
		patch -p1 <$wd/$lirc
#	fi
	cd "$wd"
fi

echo

echo -ne "Apply Packet CD writing patch? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
	patch -p1 <$wd/$packet
	cd "$wd"
fi
echo


#echo -ne "Apply Quickcam Express/Web Driver patch? [Y/n]: Y\b"
#choise="Y"
#read choise
#if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
#	cd $kdir/linux-$kver
#	patch -p1 <$wd/$quickcam
#	cd "$wd"
#fi
#echo


#echo -ne "Apply Supermount patch? [Y/n]: Y\b"
#choise="Y"
#read choise
#if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
#	cd $kdir/linux-$kver
#	patch -p1 <$wd/$sm
#	cd "$wd"
#fi
#echo


echo -ne "Apply nVIDIA video driver patch? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	echo -n "If you have $nvdrv.run already downloaded, enter the path to the file, otherwise press enter [eg. /home/me]: "
	nvdir=""
	read nvdir
	if [ "$nvdir" = "" ];then
		nvdir="nowhere"
	fi
	if [ ! -f "$nvdir/$nvdrv.run" ] && [ "$nvdir" != "nowhere" ];then
		echo -e "\nPlease check where you put $nvdrv.run and run this script again"
		exit 1
	elif [ "$nvdir" = "nowhere" ];then
		echo -ne "Would you like to try downloading $nvdrv.run? (You have to be connected to the internet and have wget installed) [Y/n] Y\b"
		choise="Y"
		read choise
		if [ "$choise" = "n" ] || [ "$choise" = "N" ];then
			echo
			echo "Ok, download it manually, then restart the script."
			exit 1
		fi
		echo
		echo "Starting download..."
		wget -c http://download.nvidia.com/XFree86/Linux-x86/$nvver/$nvdrv.run
		if [ ! -f $nvdrv.run ];then
			echo "Download was not successful, exitting..."
			cd $wd
			exit 1
		fi
	else
		cp $nvdir/$nvdrv.run .
	fi
	echo -e "\nUnpacking nVIDIA video driver..."
	rm -rf "$wd/$nvdrv"
	sh $nvdrv.run --extract-only -n
	echo
#	echo "Patching the driver..."
#	cd $nvdrv/usr/src/nv/
#	patch -p1 <$wd/$nvpatch

	cd "$wd"
	echo
	echo "Patching the kernel..."
	cd $kdir/linux-$kver
	patch -p1 <$wd/$nvidia
	cd "$wd"
	echo
	echo "Copying the needed files to the kernel source tree..."
	cp $nvdrv/usr/src/nv/* $kdir/linux-$kver/drivers/char/nvidia
	echo -e "\n\033[01;31mImportant: Please say Y to the following unless:"
	echo "1. You already installed GLX with THIS VERSION of the driver."
	echo -e "2. You're using Gentoo Linux -> emerge /usr/portage/media-video/nvidia-glx/nvidia-glx-$nvrev-r2.ebuild --nodeps -u\033[00m"
	echo -ne "\nInstall the nVIDIA GLX? [Y/n]: Y\b"
	choise="Y"
	read choise
	if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
		echo
		echo "Removing all old and conflicting files!"
		rm -f /usr/lib/libGL.*
		rm -f /usr/lib/libGLcore.*
		rm -f /usr/lib/libGLwrapper.*
		rm -f /usr/lib/tls/libGL.*
		rm -f /usr/lib/tls/libGLcore.*
		rm -f /usr/lib/tls/libGLwrapper.*
		rm -f /usr/X11R6/lib/libGL.*
		rm -f /usr/X11R6/lib/libGLcore.*
		rm -f /usr/X11R6/lib/libGLwrapper.*
		rm -f /usr/X11R6/lib/modules/extensions/libGLcore.*
		rm -f /usr/X11R6/lib/modules/extensions/libglx.*
		echo "Installing nVIDIA GLX..."
		cd $nvdrv
		install usr/lib/libGL.so.$nvrev /usr/lib
		install usr/lib/libGLcore.so.$nvrev /usr/lib
		install usr/X11R6/lib/modules/drivers/nvidia_drv.o /usr/X11R6/lib/modules/drivers
		install usr/X11R6/lib/modules/extensions/libglx.so.$nvrev /usr/X11R6/lib/modules/extensions
		
		tls=`usr/bin/tls_test 2> /dev/null; if [ "$$?" = "0" ]; then echo "1"; else echo "0"; fi`
		if [ "$tls" = "1" ]; then
			mkdir -p /usr/lib/tls;
			install usr/lib/tls/libGL.so.$nvrev /usr/lib/tls
			install usr/lib/tls/libGLcore.so.$nvrev /usr/lib/tls
			install usr/X11R6/lib/modules/extensions/tls/libglx.so.$nvrev /usr/X11R6/lib/modules/extensions
		fi
		if [ -f usr/X11R6/lib/libXvMCNVIDIA.a ]; then
			install usr/X11R6/lib/libXvMCNVIDIA.a /usr/X11R6/lib/libXvMCNVIDIA.a
		install usr/X11R6/lib/libXvMCNVIDIA.so.$nvrev /usr/X11R6/lib/libXvMCNVIDIA.so.$nvrev
		fi
		/sbin/ldconfig -n /usr/lib
		/sbin/ldconfig -n /usr/X11R6/lib
		if [ "$tls" = "1" ]; then
			/sbin/ldconfig -n /usr/lib/tls
                	cd /usr/lib/tls/; ln -fs libGL.so.$nvrev libGL.so
		fi
		cd /usr/lib/; ln -fs libGL.so.$nvrev libGL.so
		cd /usr/X11R6/lib/modules/extensions; ln -fs libglx.so.$nvrev libglx.so
		echo "Installing documentation in $nvdoc..."
		mkdir -p ${DOCDIR}/nvidia-glx-$nvrev/include
		cp -r usr/include/* ${DOCDIR}/nvidia-glx-$nvrev/include
		cp -r usr/share/doc/* ${DOCDIR}/nvidia-glx-$nvrev

		cd "$wd"
	fi
	echo
	echo "Cleaning up..."
	rm -rf $nvdrv
fi
echo

echo "Applying LNX patches..."
cd $kdir/linux-$kver
patch -p1 <$wd/$lnx
patch -p1 <$wd/$vt

echo
echo "Moving kernel tree..."
cd $kdir
mv linux-$kver linux-$kver-`cat $wd/patch-LNX |grep "+EXTRAVERSION"|cut -d "-" -f2`

echo

echo "All Done."
echo "Now compile your kernel, eg. cd $kdir/linux-$kver-`cat $wd/patch-LNX |grep "+EXTRAVERSION"|cut -d "-" -f2`;make menuconfig;make install"
